<?php if (isset($service_photos) && $service_photos[6]){ ?>
    <section class="position-relative">
        <div class="container">
            <img src="<?php echo base_url(); ?>assets/images/service-bg-01.jpg" class="position-absolute bottom-10px right-0px z-index-minus-1" data-bottom-top="transform: translateY(150px)" data-top-bottom="transform: translateY(-150px)" alt=""/>
            <style>
                .iconn-section {
                    display: flex;
                    flex-wrap: wrap;
                    align-items: flex-start;
                    gap: 20px;
                }

                .iconn-text {
                    flex: 1 1 50%;
                    max-width: 50%;
                }

                .iconn-right-images {
                    display: flex;
                    flex-direction: column;
                    gap: 20px;
                    flex: 1 1 40%;
                    max-width: 40%;
                }

                .iconn-bottom-images {
                    display: flex;
                    flex-direction: row;
                    gap: 20px;
                    flex: 1 1 40%;
                    max-width: 100%%;
                }

                .iconn-bottom-images img {
                    width: 45%;
                    height: auto;
                    border-radius: 8px;
                    object-fit: contain;
                    transition: transform 0.3s ease;
                }

                .iconn-right-images img {
                    max-width: 100%;
                    height: auto;
                    border-radius: 6px;
                }
            </style>

            <?php
            libxml_use_internal_errors(true); // HTML hatalarına takılmasın

            $doc = new DOMDocument();
            $doc->loadHTML(mb_convert_encoding($service_photos[6]->description, 'HTML-ENTITIES', 'UTF-8'));

            $xpath = new DOMXPath($doc);

            // Tüm <img> tag'lerini al
            $imgTags = $xpath->query("//img");

            $images = [];
            foreach ($imgTags as $img) {
                $images[] = $img->getAttribute('src');
                $img->parentNode->removeChild($img); // <img> etiketlerini temizle
            }

            // Geriye kalan sadece metin içeriği
            $cleanedContent = $doc->saveHTML($doc->getElementsByTagName('body')->item(0));

            ?>
            <div class="iconn-section">
                <!-- Yazı kısmı -->
                <div class="iconn-text">
                    <h2 class="fw-700 ls-minus-1px text-dark-gray mb-20px">
                        <?php echo $service_photos[6]->title; ?>
                    </h2>
                    <p class="fs-26 text-dark-gray">
                        <?= $cleanedContent; ?>
                    </p>

                    <!-- Alt görseller -->
                    <div class="iconn-bottom-images">
                        <img src="<?php if (isset($images[2])){echo $images[2];} ; ?>" alt="">
                        <img src="<?php if (isset($images[3])){echo $images[3];} ; ?>" alt="">
                    </div>
                </div>

                <!-- Sağdaki görseller -->
                <div class="iconn-right-images">
                    <img src="<?php if (isset($images[0])){echo $images[0];} ; ?>" alt="">
                    <img src="<?php if (isset($images[1])){echo $images[1];} ; ?>" alt="">
                </div>
            </div>

        </div>
    </section>
<?php } ?>


