<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Veriler_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();

        $this->db = $this->load->database('default', TRUE);
        $this->pageConf = $this->config->item("Blog", "pages");

    }

    public function toplam_kayit($where = array("isActive" => 1))
    {
        $this->db->where($where);
        return $this->db->count_all_results("blog"); // Blog adlı tablodaki kayıt sayısını döndür
    }

    public function listele($limit, $start,$activeLang,  $where = array("isActive" => 1))
    {
        $this->db->limit($limit, $start);

		$this->db->select('b.id, b.category_id, b.img_url, b.created_at, b.description_'.$activeLang->description.' as description, b.title_'.$activeLang->description.' as title, b.short_title_'.$activeLang->description.' as short_title');
		$this->db->select('b.seo_des_'.$activeLang->description.' as seo_des, bc.title_'.$activeLang->description.' as bcTitle, bc.short_title_'.$activeLang->description.' as bcShort_title');
		$this->db->from('blog b');
		$this->db->join('blog_category bc', 'b.category_id = bc.id', 'left');
		$this->db->where($where);
		$this->db->order_by("b.id", "DESC");
        $veriler = $this->db->get();

        return $veriler->result();
    }

    public function get_all($where = array("isActive" => 1), $limit="", $start)
    {
        if (!empty($where)) {
            $this->db->where($where);
        }

        if (!empty($start)) {
            $this->db->limit($start);
        }

        if (!empty($order_by)) {
            $this->db->order_by($order_by);
        }


        if ($limit) {

            $rows = $this->db
                ->get($this->pageConf["table"], $limit)
                ->result();

        } else {

            $rows = $this->db
                ->get($this->pageConf["table"])
                ->result();

        }

        return $rows;

    }

}
