<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function goback()
{
	$CI =& get_instance();
	$ref = $CI->input->server('HTTP_REFERER', TRUE);
	redirect($ref, 'location');
	die();
}

function isLogin(){

	$CI = &get_instance();

	$user = $CI->session->userdata("user");

	if(!$user){
		redirect(base_url("giris"));
	}

}

function getMacAddress(){

	$mac='UNKNOWN';
	foreach(explode("\n",str_replace(' ','',trim(`getmac`,"\n"))) as $i)
		if(strpos($i,'Tcpip')>-1){$mac=substr($i,0,17);break;}

	return $mac;
}

function getActiveUser()
{
	$CI = &get_instance();

	$user = $CI->session->userdata("user");

	if ($user) {

		$CI->load->model("User_model");

		$activeUser = $CI->User_model->get(array("id" => $user->id));

		return $activeUser;
	};
}

function set_log($log_text)
{

	$this_ =& get_instance();
	$this_->load->model("log_model");

	$log = array(
		"log" => $log_text,
		"created_date" => date("Y-m-d H:i:s"),

	);

	$this_->log_model->add($log);

}

function setSuccessAlert($message = "İşlem Başarılı !")
{

	$CI = &get_instance();

	$CI->session->set_userdata
	(
		array
		(
			"alert-type" => "success",
			"alert" => $message
		)
	);

}

function setErrorAlert($message = "İşlem Başarısız !")
{

	$CI = &get_instance();

	$CI->session->set_userdata
	(
		array
		(
			"alert-type" => "error",
			"alert" => $message
		)
	);

}

function sendMail($sender = array("email" => "", "cc" => "", "bcc" => ""), $sendMail = array("subject" => "", "message" => "", "attach" => "")){


	require APPPATH.'third_party/PHPMailer/Exception.php';
	require APPPATH.'third_party/PHPMailer/PHPMailer.php';
	require APPPATH.'third_party/PHPMailer/SMTP.php';

	$mail = new PHPMailer(true);

	$CI = &get_instance();
	$CI->load->model("Email_model");

	$email_setting = new stdClass();
	$email_setting = $CI->Email_model->get(array("isActive" => 1));

	if ($email_setting) { // Eger Herhangi Bir Email Ayari kayit yapilmissa...
		try {
			//Server settings
			$mail->CharSet = 'UTF-8';
			$mail->SMTPDebug = 2; // debug on - off
			$mail->isSMTP();
			$mail->Host = $email_setting->host; // SMTP sunucusu örnek : mail.alanadi.com
			$mail->SMTPAuth = true; // SMTP Doğrulama
			$mail->Username = $email_setting->user; // Mail kullanıcı adı
			$mail->Password = $email_setting->pass; // Mail şifresi
			$mail->SMTPSecure = 'ssl'; // Şifreleme
			$mail->Port = $email_setting->port; // SMTP Port
			$mail->SMTPOptions = array(
				'ssl' => array(
					'verify_peer' => false,
					'verify_peer_name' => false,
					'allow_self_signed' => true
				)
			);

			if ($sender["email"] == "") {
				$mail->setfrom($email_setting->from, ' - İletişim Formu');
				$mail->addAddress($email_setting->to);
			}else {
				$mail->setfrom($email_setting->from, ' - İletişim Formu');
				$mail->addAddress($sender["email"]);
			}

			if ($sendMail["attach"] != ""){

				foreach ($sendMail["attach"] as $attach){
					$mail->addAttachment($attach);
				}

			}

			$mail->isHTML(true);
			$mail->Subject = $sendMail["subject"];
			$mail->Body = $sendMail["message"];

			$mail->send();

			return true;
		} catch (Exception $e) {
			echo 'Mesajınız İletilemedi. Hata: ', $mail->ErrorInfo;
			return false;
		}

	}else { // Eger belirli bir email ayarlamasi yoksa hata ver..

		$CI->session->set_userdata
		(
			array
			(
				"alert-type" => "error",
				"alert-message" => getMessage("mailSettingsError")
			)
		);
	}



}

function getMessage($key){

	$messages = array(

		"success"       => "İşlem Başarılı !",
		"error"         => "İşlem Başarısız !",
		"missingFields" => "Lütfen Tüm Alanları Doldurun !",
		"unknownUser"   => "E-Posta adresiniz hatalı !",
		"unknownPass"   => "Şifreniz hatalı !",
		"notMatchPass"  => "ifreler eşleşmiyor !",
		"welcome"       => "Hoşgeldiniz !",
		"unauthorized"  => "Bu işlem için yetkiniz yoktur !",
		"authority"     => "Üyeliğiniz,<br> henüz onaylanmamıştır.",
		"usernamefull"  => "Bu kullancı adı daha önce kullanılmştır !",
		"emailfull"     => "Bu email adresi daha önce kullanılmıştır !",
	);

	return $messages[$key];

}

function getLang2(){
	$browser_language = (string) (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) === true && $_SERVER['HTTP_ACCEPT_LANGUAGE'] !== '') ? strtok(strip_tags($_SERVER['HTTP_ACCEPT_LANGUAGE']), ',') : '';
	$browser_language = (isset($_GET['language']) === true && $_GET['language'] !== '') ? $_GET['language'] : $browser_language;
	$language = (string) '';
	switch (substr($browser_language, 0, 2)) {
		case 'tr':
			$language = 'tr';
			break;
		default:
			$language = 'en';
	}
	return $language;
}
function getLang(){
    $browser_language = (string) (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) === true && $_SERVER['HTTP_ACCEPT_LANGUAGE'] !== '') ? strtok(strip_tags($_SERVER['HTTP_ACCEPT_LANGUAGE']), ',') : '';
    $browser_language = (isset($_GET['language']) === true && $_GET['language'] !== '') ? $_GET['language'] : $browser_language;
    $language = (string) '';
    switch (substr($browser_language, 0, 2)) {
        case 'tr':
            $language = 'en';
            break;
        default:
            $language = 'en';
    }
    return $language;
}

function convertToSEO($text){
	$search2                 = array('&', 'Ä', 'ä', 'ß', 'Ç', 'ç', 'Ğ', 'ğ', 'ı', 'İ', 'Ö', 'ö', 'Ş', 'ş', 'Ü', 'ü', ' ', "+", "'", "(", ")", ",", "!", "?", "°", "’", ":", ";",'"','/',"[","]","{","}","%","ä","Ä","$","#","æ","Æ","<",">","@","è","","ê","ë","ə","ɛ","ï","Ï","ù","û","ñ","Ñ","á","í","ó","ú","\\",'/', "°", "’");
	$replace2                = array('', 'A', 'a', 'ss', 'c', 'c', 'g', 'g', 'i', 'i', 'o', 'o', 's', 's', 'u', 'u', '-', '', '', '-', '', '', '', '', '','','','','','',"-","-","-","-","-","-","-","-","-","a","a","-","-","-","e","e","e","e","e","e","i","i","u","u","n","n","a","i","o","u","-",'-',"-","-");

	$result = strtolower(str_replace($search2, $replace2, $text));

	$search     = array('--','---','----','-----');
	$replace    = array('-','-','-','-');
	$new_text = str_replace($search, $replace, $result);

	return $new_text;

}

function shortText($kelime, $str)
{
	if (empty($str) || !$str || $str >! 0){
		$str = 10;
	}
	if (strlen($kelime) > $str)
	{
		if (function_exists("mb_substr")) $kelime = mb_substr($kelime, 0, $str, "UTF-8").'...';
		else $kelime = substr($kelime, 0, $str).'...';
	}
	return $kelime;
}

function clearAllSpaces($metin){
	$metin = str_replace("&nbsp;", "", $metin);
	$metin = str_replace("/s+/", "", $metin);
	$metin = str_replace(" ", "", $metin);
	$metin = str_replace(" ", "", $metin);
	$metin = str_replace("", "", $metin);
	$metin = str_replace("/s/g", "", $metin);
	$metin = str_replace("/s+/g", "", $metin);
	$metin = trim($metin);
	return $metin;
}

function getMName($created_at)
{
	$CI = &get_instance();

	$langID = $CI->session->userdata("lang_id");
	$a = explode("-",$created_at);
	$b = $a[1];

	if ($b < 10){
		$b = ltrim($a[1],"0") - 1;
	}

	if ($langID == 1){
		$aylar = array(
			'OCAK',
			'ŞUBAT',
			'MART',
			'NİSAN',
			'MAYIS',
			'HAZİRAN',
			'TEMMUZ',
			'AĞUSTOS',
			'EYLÜL',
			'EKİM',
			'KASIM',
			'ARALIK'
		);
	}else{
		$aylar = array(
			'JAN.',
			'FEB.',
			'MARCH',
			'APRIL',
			'MAY',
			'JUNE',
			'JULY',
			'AUGU.',
			'SEPT.',
			'OCTO.',
			'NOVEM.',
			'DECEM.'
		);
	}



	return $aylar[$b];
}
