<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Product extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();

	}

	function _remap($parameter){

		$this->index($parameter);
	}

	public function index()
	{
		$viewData = new stdClass();

		$this->load->model("City_model");
		$citys                          = $this->City_model->get_all(array());
		$this->load->model("Lang_model");
		$langs                      	= $this->Lang_model->get_all(array("isActive" => 1,"isDeleted" => 0), "","id ASC");

		$getLang 	= getLang();
		$lang_id = $this->session->userdata("lang_id");
		if(empty($lang_id)){
			$lang		= $this->Lang_model->get(array("isActive" => 1,"isDeleted" => 0, "description" => $getLang), "","id ASC");
			if (isset($lang) && $lang){
				$this->session->set_userdata('lang_id',$lang->id);
			}else{
				$this->session->set_userdata('lang_id', 2);
			}

		};
		$lang_id 		= $this->session->userdata("lang_id");
		$activeLang		= $this->Lang_model->get(array("id" => $lang_id));

		//JOIN OLAYI
		$this->db->select('c.*, ct.title as cTitle, cn.title as cnTitle');
		$this->db->from('contact c');
		$this->db->join('city ct', 'c.city_id = ct.id', 'left');
		$this->db->join('county cn', 'c.county_id = cn.id', 'left');
		$this->db->order_by("c.id", "ASC");
		$this->db->where("c.id", $lang_id);
		$contact = $this->db->get()->row();

		$this->load->model("Word_To_Lang_model");
		$this->load->model("Gallery_model");
		$words                      	= $this->Word_To_Lang_model->get_all(array("lang_id" => $lang_id), "", "id ASC");
		$gallerys                      	= $this->Gallery_model->get_all(array(), "", "id ASC");

        $this->db->select('p.id, p.img_url, p.title_'.$activeLang->description.' as title, p.location_'.$activeLang->description.' as url');
        $this->db->from('value p');
        $this->db->where("p.isActive", 1);
        $this->db->order_by("p.id", "ASC");
        $values = $this->db->get()->result();

        $this->db->select('b.id, b.title_'.$activeLang->description.' as title, 
        b.description_'.$activeLang->description.' as description,
        b.btn_title_'.$activeLang->description.' as btn_title,
        b.btn_url_'.$activeLang->description.' as btn_url,
         b.img_url');
        $this->db->from('brand b');
        $this->db->where("b.isActive", 1);
        $this->db->order_by("b.id", "ASC");
        $brands = $this->db->get()->result();

        $this->db->select('p.id,
        p.title_'.$activeLang->description.' as title, 
        p.description_'.$activeLang->description.' as description, 
        p.img_url');
        $this->db->from('project p');
        $this->db->where("p.isActive", 1);
        $this->db->order_by("p.rank", "ASC");
        $projects = $this->db->get()->result();


        $this->db->select('a.id,
        a.title_'.$activeLang->description.' as title, 
        a.description_'.$activeLang->description.' as description, 
        a.btn_title_'.$activeLang->description.' as btn_title,
        a.btn_url_'.$activeLang->description.' as btn_url,
        a.img_url');
        $this->db->from('app a');
        $this->db->where("a.isActive", 1);
        $this->db->order_by("a.id", "ASC");
        $apps = $this->db->get()->result();

		$viewData->contact              = $contact;
		$viewData->citys                = $citys;
		$viewData->langs            	= $langs;
		$viewData->lang_id          	= $lang_id;
		$viewData->words            	= $words;
		$viewData->gallerys            	= $gallerys;
		$viewData->values 			= $values;
		$viewData->brands 			    = $brands;
		$viewData->projects 		    = $projects;
		$viewData->apps 		        = $apps;
		$viewData->activeLang 			= $activeLang;
		$viewData->activePage           = "value";

		$parameter = $this->uri->segment(2);

		if (isset($parameter) && $parameter){
			$this->db->select('au.id, au.img_url, au.title_'.$activeLang->description.' as title, au.short_title_'.$activeLang->description.' as short_title, au.description_'.$activeLang->description.' as description');
			$this->db->from('about_us au');
			$this->db->where("au.isActive", 1);
			$this->db->where("au.short_title_".$activeLang->description, $parameter);
			$this->db->order_by("au.id", "ASC");
			$about 	= $this->db->get()->row();

			if ($about){

				$viewData->about            	= $about;
				$viewData->seo_title            = $contact->seo_title;
				$viewData->seo_key              = $contact->seo_key;
				$viewData->seo_des              = $contact->seo_des;

				$this->load->view('pages/value/detail', $viewData);

			}else{

				$viewData->seo_title            = $contact->seo_title;
				$viewData->seo_key              = $contact->seo_key;
				$viewData->seo_des              = $contact->seo_des;

				$this->load->view('pages/value/index', $viewData);

			}

		}else{

			$viewData->seo_title            = $contact->seo_title;
			$viewData->seo_key              = $contact->seo_key;
			$viewData->seo_des              = $contact->seo_des;

			$this->load->view('pages/value/index', $viewData);

		}


	}


}
