<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class AboutUs extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();

	}

	public function index()
	{
		$viewData = new stdClass();

		$this->load->model("City_model");
		$citys                          = $this->City_model->get_all(array());
		$this->load->model("Lang_model");
		$langs                      	= $this->Lang_model->get_all(array("isActive" => 1,"isDeleted" => 0), "","id ASC");

		$getLang 	= getLang();
		$lang_id = $this->session->userdata("lang_id");
		if(empty($lang_id)){
			$lang		= $this->Lang_model->get(array("isActive" => 1,"isDeleted" => 0, "description" => $getLang), "","id ASC");
			if (isset($lang) && $lang){
				$this->session->set_userdata('lang_id',$lang->id);
			}else{
				$this->session->set_userdata('lang_id', 2);
			}

		};
		$lang_id 		= $this->session->userdata("lang_id");
		$activeLang		= $this->Lang_model->get(array("id" => $lang_id));

		//JOIN OLAYI
		$this->db->select('c.*, ct.title as cTitle, cn.title as cnTitle');
		$this->db->from('contact c');
		$this->db->join('city ct', 'c.city_id = ct.id', 'left');
		$this->db->join('county cn', 'c.county_id = cn.id', 'left');
		$this->db->order_by("c.id", "ASC");
		$this->db->where("c.id", $lang_id);
		$contact = $this->db->get()->row();

		$this->load->model("Word_To_Lang_model");
		$this->load->model("Gallery_model");
		$words                      	= $this->Word_To_Lang_model->get_all(array("lang_id" => $lang_id), "", "id ASC");
		$gallerys                      	= $this->Gallery_model->get_all(array(), "", "id ASC");

		$this->db->select('au.id, au.img_url, au.title_'.$activeLang->description.' as title, au.short_title_'.$activeLang->description.' as short_title, au.description_'.$activeLang->description.' as description');
		$this->db->from('about_us au');
		$this->db->where("au.isActive", 1);
        $this->db->order_by("au.rank", "ASC");
		$about_us = $this->db->get()->result();

        $this->db->select('s.id, s.img_url, s.title_'.$activeLang->description.' as title, s.description_'.$activeLang->description.' as description, s.short_title_'.$activeLang->description.' as short_title');
        $this->db->select('s.seo_des_'.$activeLang->description.' as seo_des, s.seo_title_'.$activeLang->description.' as seo_title, s.icon');
        $this->db->from('service s');
        $this->db->order_by("s.rank", "ASC");
        $this->db->where("s.isActive", 1);
        $services = $this->db->get()->result();

        $this->db->select('p.id, p.img_url, p.title_'.$activeLang->description.' as title, p.description_'.$activeLang->description.' as description');
        $this->db->from('value p');
        $this->db->where("p.isActive", 1);
        $this->db->order_by("p.id", "ASC");
        $values = $this->db->get()->result();

        $this->db->select('i.id, i.img_url, i.title_'.$activeLang->description.' as title, i.description_'.$activeLang->description.' as description, i.short_title_'.$activeLang->description.' as short_title');
        $this->db->select('i.seo_des_'.$activeLang->description.' as seo_des, i.seo_title_'.$activeLang->description.' as seo_title, i.icon');
        $this->db->from('industry i');
        $this->db->order_by("i.rank", "ASC");
        $this->db->where("i.isActive", 1);
        $industrys = $this->db->get()->result();

        $this->db->select('b.id, b.seo_des_'.$activeLang->description.' as seo_des, b.category_id, b.img_url, b.created_at, b.description_'.$activeLang->description.' as description, b.title_'.$activeLang->description.' as title, b.short_title_'.$activeLang->description.' as short_title');
        $this->db->select('bc.title_'.$activeLang->description.' as bcTitle, bc.short_title_'.$activeLang->description.' as bcShort_title');
        $this->db->from('blog b');
        $this->db->join('blog_category bc', 'b.category_id = bc.id', 'left');
        $this->db->order_by("b.rank", "ASC");
        $this->db->where("b.isActive", 1);
        $this->db->limit(3);
        $blogs = $this->db->get()->result();

		$viewData->contact              = $contact;
		$viewData->citys                = $citys;
		$viewData->langs            	= $langs;
		$viewData->lang_id          	= $lang_id;
		$viewData->words            	= $words;
		$viewData->gallerys            	= $gallerys;
		$viewData->values 			= $values;
		$viewData->services 			= $services;
		$viewData->about_us 			= $about_us;
		$viewData->industrys 			= $industrys;
		$viewData->blogs 			    = $blogs;
		$viewData->activeLang 			= $activeLang;
		$viewData->activePage           = "about_us";

        $viewData->seo_title            = $contact->seo_title;
        $viewData->seo_key              = $contact->seo_key;
        $viewData->seo_des              = $contact->seo_des;

        $this->load->view('pages/about_us/index', $viewData);


	}

    public function team(){

        $viewData = new stdClass();

        $this->load->model("City_model");
        $citys                          = $this->City_model->get_all(array());
        $this->load->model("Lang_model");
        $langs                      	= $this->Lang_model->get_all(array("isActive" => 1,"isDeleted" => 0), "","id ASC");

        $getLang 	= getLang();
        $lang_id = $this->session->userdata("lang_id");
        if(empty($lang_id)){
            $lang		= $this->Lang_model->get(array("isActive" => 1,"isDeleted" => 0, "description" => $getLang), "","id ASC");
            if (isset($lang) && $lang){
                $this->session->set_userdata('lang_id',$lang->id);
            }else{
                $this->session->set_userdata('lang_id', 2);
            }

        };
        $lang_id 		= $this->session->userdata("lang_id");
        $activeLang		= $this->Lang_model->get(array("id" => $lang_id));

        $this->load->model("Word_To_Lang_model");
        $words                      	= $this->Word_To_Lang_model->get_all(array("lang_id" => $lang_id), "", "id ASC");

        //JOIN OLAYI
        $this->db->select('c.*, ct.title as cTitle, cn.title as cnTitle');
        $this->db->from('contact c');
        $this->db->join('city ct', 'c.city_id = ct.id', 'left');
        $this->db->join('county cn', 'c.county_id = cn.id', 'left');
        $this->db->order_by("c.id", "ASC");
        $this->db->where("c.id", $lang_id);
        $contact = $this->db->get()->row();


        $this->db->select('s.id, s.img_url, s.title_'.$activeLang->description.' as title, s.description_'.$activeLang->description.' as description, s.short_title_'.$activeLang->description.' as short_title');
        $this->db->select('s.seo_des_'.$activeLang->description.' as seo_des, s.seo_title_'.$activeLang->description.' as seo_title, s.icon');
        $this->db->from('service s');
        $this->db->order_by("s.rank", "ASC");
        $this->db->where("s.isActive", 1);
        $services = $this->db->get()->result();


        $this->db->select('i.id, i.img_url, i.title_'.$activeLang->description.' as title, i.description_'.$activeLang->description.' as description, i.short_title_'.$activeLang->description.' as short_title');
        $this->db->select('i.seo_des_'.$activeLang->description.' as seo_des, i.seo_title_'.$activeLang->description.' as seo_title, i.icon');
        $this->db->from('industry i');
        $this->db->order_by("i.rank", "ASC");
        $this->db->where("i.isActive", 1);
        $industrys = $this->db->get()->result();

        $team_categorys = array();

        $this->db->select('tc.id, tc.title_'.$activeLang->description.' as title, tc.description_'.$activeLang->description.' as description, tc.short_title_'.$activeLang->description.' as short_title');
        $this->db->from('team_category tc');
        $this->db->order_by("tc.rank", "ASC");
        $this->db->where("tc.isActive", 1);
        foreach ($this->db->get()->result() as $tc){
            $this->db->select('tp.id, tp.img_url, tp.name, tp.linkedin, tp.title_'.$activeLang->description.' as title, tp.description_'.$activeLang->description.' as description');
            $this->db->from('team_photo tp');
            $this->db->order_by("tp.id", "ASC");
            $this->db->where("tp.isActive", 1);
            $this->db->where("tp.team_id", $tc->id);
            $tc->photos = $this->db->get()->result();
            array_push($team_categorys, $tc);
        }

        $viewData->contact              = $contact;
        $viewData->citys                = $citys;
        $viewData->langs            	= $langs;
        $viewData->lang_id          	= $lang_id;
        $viewData->words            	= $words;
        $viewData->services 			= $services;
        $viewData->industrys 			= $industrys;
        $viewData->team_categorys       = $team_categorys;
        $viewData->activeLang 			= $activeLang;
        $viewData->activePage           = "team";

        $viewData->seo_title            = $contact->seo_title;
        $viewData->seo_key              = $contact->seo_key;
        $viewData->seo_des              = $contact->seo_des;

        $this->load->view('pages/team/index', $viewData);

    }

}
